/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.lpar;

import com.ibm.hsc.auiml.databeans.lpar.HSCDLPARBean;
import com.ibm.hsc.auiml.databeans.lpar.HSCDProcMemBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskNotifyCompleteListener;
import com.ibm.ui.framework.TaskSelectionListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOXContainerObj;

public abstract class DlparDialog {
    public static final String DLPAR_BUNDL_NAME = "DLPARBundle";
    public static final String ERR_DLPAR_NOT_ENABLED = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_DLPAR_NOT_ENABLED", "HMCERRV3DLPAR016: The current selected partition is not enabled for dynamic reconfiguration operations.");

    protected abstract String getNoResError();

    protected abstract HSCDLPARBean getBeanExtObj();

    public void createDialog(MOXContainerObj mOXContainerObj) {
        HSCDLPARBean hSCDLPARBean = this.getBeanExtObj();
        try {
            hSCDLPARBean.setServerConn(mOXContainerObj);
            if (IDebug.enabled) {
                System.out.println("before bean load");
            }
            hSCDLPARBean.load();
            if (hSCDLPARBean.getLoadException() != null) {
                return;
            }
            if (!hSCDLPARBean.dlparEnabled()) {
                hSCDLPARBean.showInfo(ERR_DLPAR_NOT_ENABLED, null, null);
                return;
            }
            if (hSCDLPARBean.needToDisableAll()) {
                hSCDLPARBean.showInfo(this.getNoResError(), null, null);
                return;
            }
            if (IDebug.enabled) {
                System.out.println("after bean load");
            }
            DataBean[] dataBeanArray = new DataBean[]{hSCDLPARBean};
            AuimlAdapter auimlAdapter = new AuimlAdapter(hSCDLPARBean.getAuimlClassName(), hSCDLPARBean.getMainPanelName(), dataBeanArray);
            UserTaskManager userTaskManager = auimlAdapter.getUserTaskManager();
            hSCDLPARBean.setUsrTaskMgr(userTaskManager);
            userTaskManager.addTaskSelectionListener((TaskSelectionListener)hSCDLPARBean, hSCDLPARBean.getTaskGroupName());
            if (hSCDLPARBean.getMoveDestName() != null) {
                userTaskManager.addTaskNotifyCompleteListener((TaskNotifyCompleteListener)((HSCDProcMemBean)hSCDLPARBean), hSCDLPARBean.getMoveDestName());
            }
            userTaskManager.addTaskActionListener((TaskActionListener)hSCDLPARBean);
            auimlAdapter.showIt();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            hSCDLPARBean.handleException(throwable);
        }
    }
}

